<%@page contentType="text/html;charset=utf-8"%>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ko" xml:lang="ko">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />	
	<title>IBSTab & IBUpoad Sample</title>
	
	<link rel="stylesheet" href="../common/css/style.css"/>
	<link rel="stylesheet" href="../product/tab/css/font-awesome.min.css" />
    <link rel="stylesheet" href="../product/tab/css/ibtab-style.min.css" />

	<script type="text/javascript" src="../common/js/public.js"></script>
	<script type="text/javascript" src="../product/tab/ibtab.js"></script>
	<script type="text/javascript" src="../product/tab/ibtabinfo.js"></script>
    
	<script type="text/javascript">
		$(function() {
			$("#tree").treeview({
				collapsed: false,
				animated: "medium",
				control:"#sidetreecontrol",
				persist: "location"
			});
		})
		//텝에서는 가급적 $(document).ready()를 쓰지말고 OnLoad 이벤트를 사용해야 한다.
		function pageInit(){
			
			var tabBar = document.getElementById("tab_main"),
			contents = document.getElementById("content");
			
			createIBTab(tabBar,contents,"mainTabs",{
				widthTabBar: "100%",
			   // widthContents: $(window).width()-240+"px",
				widthContents: "calc(100% - 240px)",
				heightContents:"calc(100% - 80px)",
				allowCloseBTN: false
			});
			mainTabs.setThemes({
				  tabs: "simple_under_blue",
				  contents: "simple_under_blue",
				  contextMenu: "simple_under_blue"
				});
			mainTabs.addTab({
				tabs:{
					title:"기본기능",
					focus:true
				},
				contents:{
					type:"iframe",
					contents:"sample/tab01.html"
				}
			});
			
			$("#tree>li").each(function(idx){
				$(this).bind("click",function(){
					var tempIdx = FindTabTitle($(this).text());
					if(tempIdx==-1){
						mainTabs.addTab({
							tabs:{
								title:$(this).text(),
								focus:true
							},
							contents:{
								type:"iframe",
								contents:"sample/tab0"+(idx+1)+".html"
							}
						});
					}else{
						mainTabs.goToTab(tempIdx);
					}
				});
			});
			//findTabTitle
			function FindTabTitle(Title) {
				var index = new Array();
				var i = 0;
				
				while(i < mainTabs.tabs.getCountTab()){
					index[i] = mainTabs.tabs.items(i).getTitle();
					if (index[i] == Title) {
						return i;
						break;
					}else
						i++;
				}
				return -1;
			}

		}
		
		function MainTab_OnCloseAll(){
			
			//1.모든 텝을 제거
		//	MainTab.RemoveAll();

			//2. 현재 선택된 텝을 제외하고 모두 닫음.
			for(var i = mainTabs.getCount(); i > -1; i--){
				/* if(i != mainTabs.GetSelectedIndex()){
					MainTab.DeleteItem(i);
				} */
			}
		}
			
	</script>
</head>

<body onload="pageInit()">

	<jsp:include page="../topmenu.jsp" />
    
	
		<div id="navigation" class="bg_sub">
        
            <div id="leftmenu">
            
                <jsp:include page="../leftmenu.jsp" />
              <div class="depth2_box"  id="menu_id">
                <div class="depth2">
                
                		<h2>IBTab</h2>
                        <div id="sidetree">
                        
                                <div id="sidetreecontrol" ><!--<a href="?#">+ 접기</a>  <a href="?#">- 풀기</a>--></div>
                                
                                <ul id="tree">
                                    <li><a href="#"><strong>기본 기능</strong></a></li>
                               		<li><a href="#"><strong>iframe/Link 활용</strong></a></li>
                                    <li><a href="#"><strong>테마 기능</strong></a></li>
                                    <li><a href="#"><strong>탭 바 위치 변경</strong></a></li>
                                </ul>
                           </div>
                        	<!--slidetree-->
                        </div>
                        <!--depth2-->
                </div>
                <!--2depth-->
	        </div>
	            <!--//leftmenu-->
        </div>
		<div id="tab_main" class="ib-tab-tabs" style="display: none;left: 240px;"></div>
		<div id="content" class="ib-tab-contents" style="width:100%"> </div>
		
</body>
</html>








